VERSION 5.00
Object = "{5EB78BCC-023B-11D4-9AA7-0080ADC7FBD4}#1.2#0"; "ucNumBox.ocx"
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Object = "{40189C3D-6EA8-11D4-9AAA-0080ADC7FBD4}#5.1#0"; "ucFramedLabel.ocx"
Object = "{B0CDA449-A5E0-11D3-9AA5-0080ADC7FBD4}#34.1#0"; "ucGraphLabel.ocx"
Begin VB.Form frmIngresoCaja 
   Caption         =   "Ingreso de caja"
   ClientHeight    =   6060
   ClientLeft      =   4065
   ClientTop       =   3615
   ClientWidth     =   9435
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   ScaleHeight     =   6060
   ScaleWidth      =   9435
   StartUpPosition =   2  'CenterScreen
   Begin VB.ComboBox cbxMedio 
      Height          =   315
      Left            =   150
      TabIndex        =   12
      Tag             =   "GED_Medio"
      Text            =   "Combo1"
      Top             =   1140
      Visible         =   0   'False
      Width           =   1305
   End
   Begin prjUcFramedLabel.ucFramedLabel lblVuelto 
      Height          =   285
      Left            =   6900
      Top             =   4800
      Width           =   2445
      _ExtentX        =   4313
      _ExtentY        =   503
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   7
      Caption         =   ""
      FontName        =   "MS Sans Serif"
      FontSize        =   9,75
      MargenH         =   90
   End
   Begin prjUcFramedLabel.ucFramedLabel lblTotalRecibido 
      Height          =   285
      Left            =   6900
      Top             =   4470
      Width           =   2445
      _ExtentX        =   4313
      _ExtentY        =   503
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   7
      Caption         =   ""
      FontName        =   "MS Sans Serif"
      FontSize        =   9,75
      MargenH         =   90
   End
   Begin ucGraphLabel.ucGraphicLabel cbOk 
      Height          =   555
      Left            =   5790
      TabIndex        =   10
      Top             =   5190
      Width           =   1725
      _ExtentX        =   3043
      _ExtentY        =   979
      Enabled         =   0   'False
      LabelX          =   90
      LabelY          =   120
      Picture         =   "frmIngresoCaja.frx":0000
      Caption         =   "Aceptar (O&k)"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin prjUcFramedLabel.ucFramedLabel lblMontoVenta 
      Height          =   255
      Left            =   1560
      Top             =   4560
      Width           =   1605
      _ExtentX        =   2831
      _ExtentY        =   450
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   7
      Caption         =   ""
      FontName        =   "MS Sans Serif"
      FontSize        =   8,25
      MargenH         =   60
   End
   Begin MSComctlLib.StatusBar StatusBar1 
      Align           =   2  'Align Bottom
      Height          =   285
      Left            =   0
      TabIndex        =   9
      Top             =   5775
      Width           =   9435
      _ExtentX        =   16642
      _ExtentY        =   503
      _Version        =   393216
      BeginProperty Panels {8E3867A5-8586-11D1-B16A-00C0F0283628} 
         NumPanels       =   1
         BeginProperty Panel1 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            AutoSize        =   1
            Object.Width           =   16113
         EndProperty
      EndProperty
   End
   Begin MSFlexGridLib.MSFlexGrid flxMedios 
      Height          =   3915
      Left            =   90
      TabIndex        =   2
      Top             =   510
      Width           =   9255
      _ExtentX        =   16325
      _ExtentY        =   6906
      _Version        =   393216
      Cols            =   4
      FixedCols       =   0
      RowHeightMin    =   285
      FormatString    =   $"frmIngresoCaja.frx":031A
   End
   Begin ucNumero.ucNumBox numEfectivo 
      Height          =   315
      Left            =   1440
      TabIndex        =   1
      Top             =   90
      Width           =   1785
      _ExtentX        =   3149
      _ExtentY        =   556
      Enabled         =   -1  'True
      ShowCalc        =   -1  'True
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin prjUcFramedLabel.ucFramedLabel lblMontoIVA 
      Height          =   255
      Left            =   1560
      Top             =   4860
      Width           =   1605
      _ExtentX        =   2831
      _ExtentY        =   450
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   7
      Caption         =   ""
      FontName        =   "MS Sans Serif"
      FontSize        =   8,25
      MargenH         =   60
   End
   Begin prjUcFramedLabel.ucFramedLabel lblNotasCredito 
      Height          =   255
      Left            =   1560
      Top             =   5160
      Width           =   1605
      _ExtentX        =   2831
      _ExtentY        =   450
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   7
      Caption         =   ""
      FontName        =   "MS Sans Serif"
      FontSize        =   8,25
      MargenH         =   60
   End
   Begin prjUcFramedLabel.ucFramedLabel lblTotal 
      Height          =   255
      Left            =   1560
      Top             =   5460
      Width           =   1605
      _ExtentX        =   2831
      _ExtentY        =   450
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Alignment       =   7
      Caption         =   ""
      FontName        =   "MS Sans Serif"
      FontSize        =   8,25
      MargenH         =   60
   End
   Begin ucGraphLabel.ucGraphicLabel cbCancelar 
      Cancel          =   -1  'True
      Height          =   555
      Left            =   7590
      TabIndex        =   11
      Top             =   5190
      Width           =   1755
      _ExtentX        =   3096
      _ExtentY        =   979
      Enabled         =   0   'False
      LabelX          =   90
      LabelY          =   120
      Picture         =   "frmIngresoCaja.frx":03D3
      Caption         =   "Cancelar (Esc)"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Color           =   -2147483633
   End
   Begin VB.Label Label8 
      AutoSize        =   -1  'True
      Caption         =   "Total a cobrar:"
      Height          =   225
      Left            =   120
      TabIndex        =   8
      Top             =   5460
      Width           =   1035
   End
   Begin VB.Label Label7 
      AutoSize        =   -1  'True
      Caption         =   "Notas de credito:"
      Height          =   195
      Left            =   120
      TabIndex        =   7
      Top             =   5160
      Width           =   1215
   End
   Begin VB.Label Label6 
      AutoSize        =   -1  'True
      Caption         =   "Monto del I.V.A.:"
      Height          =   195
      Left            =   120
      TabIndex        =   6
      Top             =   4860
      Width           =   1185
   End
   Begin VB.Label Label5 
      AutoSize        =   -1  'True
      Caption         =   "Monto de la Venta:"
      Height          =   195
      Left            =   120
      TabIndex        =   5
      Top             =   4560
      Width           =   1350
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "Vuelto:"
      Height          =   195
      Left            =   6315
      TabIndex        =   4
      Top             =   4830
      Width           =   495
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Total Recibido:"
      Height          =   195
      Left            =   5730
      TabIndex        =   3
      Top             =   4500
      Width           =   1080
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Efectivo:"
      Height          =   195
      Left            =   90
      TabIndex        =   0
      Top             =   120
      Width           =   630
   End
End
Attribute VB_Name = "frmIngresoCaja"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private geditor As GEDObject

Private Const COL_MEDIO = 0, COL_DETALLES = 1, COL_MONTO = 2, COL_ID_DETALLE = 3
Private combo As New clsCombo
Private bResult As Boolean, Total As Currency
Private DetallesIngreso As New Collection
Public bAutoCierre As Boolean, bAutoFill As Boolean

Private Function UltimoDetalle() As Long
  Dim l As Long
  With flxMedios
    Dim i As Long
    For i = .FixedRows To .Rows - 1
      Dim c As Long
      c = ValOf(.TextMatrix(i, COL_ID_DETALLE))
      If c > l Then l = c
    Next
  End With
  UltimoDetalle = l
End Function

Private Function BuscarDetalle(Id As Long) As CDetalleIngreso
Dim pDet As CDetalleIngreso
  For Each pDet In DetallesIngreso
    If pDet.Id = Id Then
      Set BuscarDetalle = pDet
      Exit Function
    End If
  Next
  Set BuscarDetalle = Nothing
End Function

Private Function ValidarForma() As Boolean
  Dim TotalRecibido As Currency
  TotalRecibido = CCur(Me.lblTotalRecibido.Caption)
  If TotalRecibido - Total < (-1) Then
    mAdvertencia "Le faltan " & Format(Total - TotalRecibido, "Currency") & " para completar el monto"
    ValidarForma = False
    Exit Function
  End If
  ValidarForma = True
End Function

Private Function LlenarIngresoCaja() As CIngresoCaja
Dim Ingreso As CIngresoCaja

  Set Ingreso = New CIngresoCaja
  Dim pDetalle As CDetalleIngreso
  Dim TotalRecibido As Currency
  TotalRecibido = CCur(Me.lblTotalRecibido.Caption)
  Ingreso.Vuelto = TotalRecibido - Total
  If TotalRecibido > Total Then
    Me.numEfectivo.value = Me.numEfectivo.value + Total - TotalRecibido
  ElseIf TotalRecibido < Total Then
    mAdvertencia "Le faltan " & Format(Total - TotalRecibido, "Currency") & " para completar el monto"
    Set LlenarIngresoCaja = Nothing
    Exit Function
  End If

  If numEfectivo.value - Ingreso.Vuelto <> 0 Then
    Set pDetalle = New CDetalleIngreso
    With pDetalle
    .Medio = "EFE"
    .Monto = numEfectivo.value - Ingreso.Vuelto
    .MontoNominal = .Monto
    End With
    If DetallesIngreso.Count > 0 Then
      DetallesIngreso.Add pDetalle, , 1
    Else
      DetallesIngreso.Add pDetalle
    End If
  End If
  
  For Each pDetalle In DetallesIngreso
    Ingreso.Debitos = Ingreso.Debitos + pDetalle.Monto
    Ingreso.colDetalles.Add pDetalle
  Next
  Set LlenarIngresoCaja = Ingreso

End Function

Private Sub UpdateTotales()
  Dim acum As Currency
  acum = Me.numEfectivo.value + geditor.SumaColumna(COL_MONTO)
  Dim Vuelto As Currency
  Vuelto = acum - Total
  If Vuelto < 0 Then
    Me.lblVuelto.ForeColor = vbRed
  Else
    Me.lblVuelto.ForeColor = vbButtonText
  End If
  Vuelto = Abs(Vuelto)
  Me.lblTotalRecibido = Format(acum, "Currency")
  Me.lblVuelto = Format(Vuelto, "Currency")
  If bAutoCierre Then
    If (acum >= Total) Then
      bResult = True
      Me.Hide
    End If
  End If
End Sub

Public Function CompletarIngresoCaja(iMontoVenta As Currency, iMontoIVA As Currency, iMontoCredito As Currency) As CIngresoCaja

  Total = iMontoVenta + iMontoIVA - iMontoCredito
  Me.lblMontoIVA.Caption = Format(iMontoIVA, "Currency")
  Me.lblMontoVenta.Caption = Format(iMontoVenta, "Currency")
  Me.lblNotasCredito.Caption = Format(-iMontoCredito, "Currency")
  Me.lblTotal.Caption = Format(Total, "Currency")

  If Me.bAutoFill Then
    Me.numEfectivo.value = iMontoVenta + iMontoIVA - iMontoCredito
  End If

  Show vbModal
  
  If bResult = False Then
    Set CompletarIngresoCaja = Nothing
  Else
    Dim f As New frmShowVuelto
    f.ShowVuelto CCur(lblVuelto.Caption)
    Set CompletarIngresoCaja = LlenarIngresoCaja
  End If

End Function

Private Sub cbCancelar_Click()
  bResult = False
  Me.Hide
End Sub

Private Sub cbOk_Click()
  Dim i As Long
  With Me.flxMedios
    For i = .Rows - 1 To .FixedRows Step -1
      If lmGridUtils.IsEmpty(flxMedios, i) Then
        If .Rows - 1 > .FixedRows Then
          .RemoveItem i
        Else
          lmGridUtils.CleanRow flxMedios, i
        End If
      End If
    Next
  End With
    
  If ValidarForma() Then
    bResult = True
    Me.Hide
  End If
End Sub

Private Sub flxMedios_Scroll()
  geditor.Scroll
End Sub

Private Sub flxMedios_GotFocus()
  geditor.EnterCell
End Sub

Private Sub flxMedios_EnterCell()
  geditor.EnterCell
End Sub

Public Function ValidateCell(nRow As Long, nCol As Long) As Boolean
Dim idDetalle As Long, CodigoMedio As String
  CodigoMedio = UCase(Trim(VSLIB.sExtractRightCode(flxMedios.TextMatrix(nRow, 0))))
  If CodigoMedio = "" Then
    If flxMedios.TextMatrix(nRow, COL_ID_DETALLE) <> "" Then
      mAdvertencia "No puede dejar el medio en blanco: elimine la fila"
      flxMedios.TextMatrix(nRow, nCol) = UCase(Trim(sExtractRightCode(Me.cbxMedio.Text)))
      ValidateCell = False
      Exit Function
    End If
    If nRow = flxMedios.Rows - 1 Then
      ValidateCell = True
      Exit Function
    End If
  End If
  flxMedios.TextMatrix(nRow, nCol) = CodigoMedio
  idDetalle = Val(flxMedios.TextMatrix(nRow, COL_ID_DETALLE))
  Dim Detalle As CDetalleIngreso
  Set Detalle = BuscarDetalle(idDetalle)
  If Not Detalle Is Nothing Then
    If Detalle.Medio = CodigoMedio Then
      ValidateCell = True
      Exit Function
    End If
  Else
    Set Detalle = New CDetalleIngreso
    Detalle.Medio = CodigoMedio
  End If
  
  Dim f As New frmDetallesMedio
  If f.EditDetalle(Detalle) Then
    If idDetalle = 0 Then
      Detalle.Id = UltimoDetalle + 1
      DetallesIngreso.Add Detalle
      Me.flxMedios.TextMatrix(nRow, COL_ID_DETALLE) = Detalle.Id
    End If
  Else
    ValidateCell = False
    Exit Function
  End If

  With flxMedios
  .TextMatrix(nRow, 1) = Detalle.ToString
  .TextMatrix(nRow, 2) = Format(Detalle.Monto, "#,##0.00")
  .TextMatrix(nRow, 3) = Detalle.Id
  End With
  
  UpdateTotales

  ValidateCell = True
End Function

Public Function IsRowValid(nRow As Long) As Boolean
  IsRowValid = True
End Function

Public Function MayAddRow(nRows As Long) As Boolean
  MayAddRow = True
End Function

Public Function MayDeleteRow(nRow As Long) As Boolean
  Dim i As Integer, idDetalle As Long
  idDetalle = ValOf(Me.flxMedios.TextMatrix(nRow, COL_ID_DETALLE))
  For i = 1 To DetallesIngreso.Count
    If DetallesIngreso(i).Id = idDetalle Then
      DetallesIngreso.Remove i
      Exit For
    End If
  Next
  flxMedios.TextMatrix(nRow, COL_MONTO) = ""
  UpdateTotales
  MayDeleteRow = True
End Function

Public Sub FillNewRow(nRow As Long)

End Sub

Private Sub Form_Initialize()
  Me.bAutoFill = CBool(GetSetting("VSL", "frmIngresoCaja", "AutoFill", "0"))
  Me.bAutoCierre = CBool(GetSetting("VSL", "frmIngresoCaja", "AutoCierre", "0"))
End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)
  TranslateReturn KeyAscii, Me.ActiveControl
End Sub

Private Sub Form_Load()
  Dim rs As Recordset
  Set rs = dbHandle.Execute("SELECT Codigo, Descripcion FROM MediosPago ORDER BY Descripcion")
  Do While Not rs.EOF
    Me.cbxMedio.AddItem GetStringFromVariant(rs!Descripcion) & " (" & GetStringFromVariant(rs!Codigo) & ")"
    rs.MoveNext
  Loop
  Set geditor = New GEDObject
  With geditor
    Set combo.ComboBox = cbxMedio
    .init Me, Me.flxMedios
    .AddControl 0, cbxMedio
    With flxMedios
      .ColWidth(COL_ID_DETALLE) = 0
      .ColAlignment(0) = flexAlignLeftCenter
      .ColAlignment(1) = flexAlignLeftCenter
      .ColAlignment(2) = flexAlignRightCenter
    End With
  End With
End Sub

Private Sub cbxMedio_LostFocus()
  geditor.ControlLost
End Sub

Private Sub cbxMedio_KeyDown(KeyCode As Integer, Shift As Integer)
  geditor.KeyDown KeyCode, Shift
End Sub

Private Sub cbxMedio_GotFocus()
  StatusBar1.Panels(1).Text = "Seleccione un medio de pago"
End Sub

Private Sub numEfectivo_GotFocus()
  StatusBar1.Panels(1).Text = "Ingrese el monto recibido en efectivo en moneda nacional"
End Sub

Private Sub numEfectivo_Validate(Cancel As Boolean)
  If numEfectivo.value < 0 Then
    mAdvertencia "Por favor, introduzca cero o un valor positivo"
    Cancel = False
  End If
  UpdateTotales
End Sub

